<?php

namespace App\Filament\Resources\Membership\MembershipPlanResource\Pages;

use App\Filament\Resources\Membership\MembershipPlanResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\View\View;
use Filament\Notifications\Notification;

class CreateMembershipPlan extends CreateRecord
{
    protected static string $resource = MembershipPlanResource::class;

    protected function getFormActions(): array
    {
        return [
            $this->getCreateFormAction()
                ->label('Create')
                ->icon('heroicon-o-plus'),
            $this->getCreateAnotherFormAction()
                ->label('Create & New')
                ->icon('heroicon-o-plus-circle'),   
            $this->getCancelFormAction()
                ->icon('heroicon-o-x-mark'),
        ];
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('create')  
                ->label('Create')
                ->icon('heroicon-o-plus')
                ->action('create')
                ->color('primary')
                ->successNotification(
                    Notification::make()
                        ->success()
                        ->title('Membership Plan Created')
                        ->body('Your membership plan has been created.')
                )
                ->keyBindings(['mod+s']),   
            Actions\Action::make('createAnother')
                ->label('Create & New')
                ->icon('heroicon-o-plus-circle')
                ->action('createAnother')
                ->color('gray')
                ->successNotification(
                    Notification::make()
                        ->success()
                        ->title('Membership Plan Created')
                        ->body('Your membership plan has been created. Create another one!')
                ),
            Actions\Action::make('cancel')
                ->label('Cancel')
                ->icon('heroicon-o-x-mark')
                ->color('gray')
                ->url(fn () => MembershipPlanResource::getUrl()),
        ];
    }

    public function getHeader(): ?View
    {
        return view('filament.pages.header', [
            'actions' => $this->getHeaderActions(),
        ]);
    }
}

