<?php

namespace App\Filament\Resources\Membership\MembershipPlanResource\Pages;

use App\Filament\Resources\Membership\MembershipPlanResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Filament\Actions\Action;
use App\Models\Membership\MembershipPlan;
use Illuminate\View\View;
use Filament\Notifications\Notification;

class EditMembershipPlan extends EditRecord
{
    protected static string $resource = MembershipPlanResource::class;

    protected function getSavedNotification(): ?Notification
    {
        return Notification::make()
            ->success()
            ->title('Membership Plan Updated')
            ->body('Your membership plan has been updated successfully.');
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('save')
                ->label('Update')
                ->action('save')
                ->icon('heroicon-o-check-circle')
                ->color('primary')
                ->keyBindings(['mod+s']),
            Actions\ViewAction::make()
                ->label('View')
                ->icon('heroicon-o-eye')
                ->color('success')
                ->url(fn () => route('filament.espadmin.resources.membership.membership-plans.view', ['record' => $this->record])),

            Actions\ActionGroup::make([
                Actions\ActionGroup::make([
                    // Array of actions
                Actions\Action::make('history')
                    ->label('View History')
                    ->icon('heroicon-o-clock')
                    ->color('info')
                    ->action(fn (MembershipPlan $record) => $record)
                    ->modalContent(view('filament.resources.includes.history', ['record' => $this->record]))
                    ->modalWidth('3xl')
                    ->modalHeading(fn (MembershipPlan $record) => 'History for ' . $record->package_title)
                    ->modalSubmitAction(false),

                Actions\DeleteAction::make()
                    ->label('Move to Trash')
                    ->icon('heroicon-o-trash')
                    ->requiresConfirmation()
                    ->hidden(fn (): bool => $this->record->trashed())
                    ->modalHeading('Delete Membership Plan')
                    ->modalDescription('Are you sure you want to delete this membership plan? This action can be undone later.')
                    ->modalSubmitActionLabel('Yes, delete it')
                    ->successNotification(
                        Notification::make()
                            ->success()
                            ->title('Membership plan deleted')
                            ->body('The membership plan has been moved to trash.')
                    ),
                ])->dropdown(false),
                Actions\Action::make('cancel')
                    ->label('Cancel')
                    ->icon('heroicon-o-x-mark')
                    ->color('gray')
                    ->url(fn () => MembershipPlanResource::getUrl()),
            ])
            ->tooltip('More Actions')
            ->icon('heroicon-m-ellipsis-vertical')
            ->color('info')
            ->button()
            ->extraAttributes([
                'class' => 'more-actions-btn',
            ]),
            
        ];
    }

    public function getHeader(): ?View
    {
        return view('filament.pages.header', [
            'actions' => $this->getHeaderActions(),
        ]);
    }
}
