<?php

namespace App\Filament\Resources\Membership\MembershipPlanResource\RelationManagers;

use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\BadgeColumn;

class SubscriptionsRelationManager extends RelationManager
{
    protected static string $relationship = 'subscriptions';

    protected static ?string $title = 'Plan Members';

    public function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('user.name')
                    ->label('Member Name')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('user.email')
                    ->label('Email')
                    ->searchable()
                    ->sortable(),
                BadgeColumn::make('payment_term')
                    ->label('Term')
                    ->colors([
                        'primary' => 'monthly',
                        'success' => 'yearly',
                        'warning' => 'quarterly',
                        'info' => 'half_yearly',
                    ]),
                IconColumn::make('is_active')
                    ->label('Status')
                    ->boolean()
                    ->trueIcon('heroicon-o-check-circle')
                    ->falseIcon('heroicon-o-x-circle')
                    ->trueColor('success')
                    ->falseColor('danger'),
                TextColumn::make('starts_at')
                    ->label('Start Date')
                    ->date()
                    ->sortable(),
                TextColumn::make('expires_at')
                    ->label('Expiry Date')
                    ->date()
                    ->sortable(),
                IconColumn::make('auto_renewal')
                    ->label('Auto Renewal')
                    ->boolean(),
            ])
            ->filters([
                // Add filters here if needed
            ])
            ->actions([
                // Add actions here if needed
            ])
            ->bulkActions([
                // Add bulk actions here if needed
            ]);
    }
}