<?php

namespace App\Filament\Resources\Membership;

use App\Filament\Resources\Membership\SubscriptionResource\Pages;
use App\Filament\Resources\Membership\SubscriptionResource\RelationManagers;
use App\Models\Membership\Subscription;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\DatePicker;
use App\Enums\MembershipPaymentTerm;

class SubscriptionResource extends Resource
{
    protected static ?string $model = Subscription::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make('Subscription Details')
                    ->description('Manage subscription information and settings')
                    ->schema([
                        Select::make('user_id')
                            ->relationship('user', 'name')
                            ->searchable()
                            ->preload()
                            ->required()
                            ->label('User'),

                        Select::make('membership_plan_id')
                            ->relationship('membershipPlan', 'package_title')
                            ->searchable()
                            ->preload()
                            ->required()
                            ->label('Membership Plan'),

                        DatePicker::make('purchase_date')
                            ->required()
                            ->label('Purchase Date')
                            ->default(now()),

                        Select::make('payment_term')
                            ->options(MembershipPaymentTerm::class)
                            ->required()
                            ->default(MembershipPaymentTerm::Monthly)
                            ->label('Payment Term'),

                        Forms\Components\Grid::make(2)
                            ->schema([
                                Toggle::make('is_active')
                                    ->required()
                                    ->label('Active Status')
                                    ->default(true),

                                Toggle::make('auto_renewal')
                                    ->required()
                                    ->label('Auto Renewal')
                                    ->default(true),
                            ]),

                        Forms\Components\Grid::make(2)
                            ->schema([
                                DatePicker::make('current_period_start')
                                    ->label('Period Start Date'),

                                DatePicker::make('current_period_end')
                                    ->label('Period End Date'),
                            ]),

                        Forms\Components\Grid::make(2)
                            ->schema([
                                DatePicker::make('trial_ends_at')
                                    ->label('Trial End Date'),

                                DatePicker::make('cancelled_at')
                                    ->label('Cancellation Date'),
                            ]),
                    ])
                    ->columns(1)
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('user.name')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('membershipPlan.package_title')
                    ->sortable(),
                Tables\Columns\TextColumn::make('purchase_date')
                    ->date()
                    ->sortable(),
                Tables\Columns\TextColumn::make('payment_term')
                    ->searchable(),
                Tables\Columns\IconColumn::make('is_active')
                    ->boolean(),
                Tables\Columns\IconColumn::make('auto_renewal')
                    ->boolean(),
                Tables\Columns\TextColumn::make('current_period_start')
                    ->date()
                    ->sortable(),
                Tables\Columns\TextColumn::make('current_period_end')
                    ->date()
                    ->sortable(),
                Tables\Columns\TextColumn::make('trial_ends_at')
                    ->date()
                    ->sortable()
            ])
            ->filters([
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListSubscriptions::route('/'),
            'create' => Pages\CreateSubscription::route('/create'),
            'view' => Pages\ViewSubscription::route('/{record}'),
            'edit' => Pages\EditSubscription::route('/{record}/edit'),
        ];
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()
            ->withoutGlobalScopes([
            ]);
    }
}
