<?php

namespace App\Filament\Resources\Membership\SubscriptionResource\Pages;

use App\Filament\Resources\Membership\SubscriptionResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use Filament\Notifications\Notification;

class CreateSubscription extends CreateRecord
{
    protected static string $resource = SubscriptionResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('create')
                ->label('Create')
                ->icon('heroicon-o-plus')
                ->action('create')
                ->color('primary')
                ->successNotification(
                    Notification::make()
                        ->success()
                        ->title('Subscription Created')
                        ->body('Your subscription has been created.')
                ),

            Actions\Action::make('createAnother')
                ->label('Create & New')
                ->icon('heroicon-o-plus-circle')
                ->action('createAnother')
                ->color('gray')
                ->successNotification(
                    Notification::make()
                        ->success()
                        ->title('Member Created')
                        ->body('Your member has been created. Create another one!')
                ),
            Actions\Action::make('cancel')
                ->label('Cancel')
                ->icon('heroicon-o-x-mark')
                ->color('gray')
                ->url(fn() => SubscriptionResource::getUrl()),
        ];
    }

    protected function beforeCreate(): void
    {
        // Set default values if needed
        $this->data['purchase_date'] = now();
    }

    protected function afterCreate(): void
    {
        // Additional logic after subscription creation
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }

    protected function getFormActions(): array
    {
        return [
            $this->getCreateFormAction()
                ->label('Create')
                ->icon('heroicon-o-plus'),
            $this->getCreateAnotherFormAction()
                ->label('Create & New')
                ->icon('heroicon-o-plus-circle'),
            $this->getCancelFormAction()
                ->icon('heroicon-o-x-mark'),
        ];
    }
}
