<?php

namespace App\Filament\Resources\Page\PageResource\Pages;

use App\Filament\Resources\Page\PageResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use App\Enums\PageStatus;
use App\Models\Page;
class CreatePage extends CreateRecord
{
    protected static string $resource = PageResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // dd($data);
        if ($data['status'] === PageStatus::Published->value) {
            $data['published_at'] = now();
            $data['expired_at'] = null;
        } elseif ($data['status'] === PageStatus::Expired->value) {
            $data['expired_at'] = now();
        } else {
            $data['published_at'] = null;
            $data['expired_at'] = null;
        }

        return $data;
    }

    protected function afterCreate(): void
    {
        /** @var Page $page */
        $page = $this->record;
    }
}
