<?php

namespace App\Filament\Resources\Page\PageResource\Pages;

use App\Filament\Resources\Page\PageResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use App\Models\Page;
use Illuminate\Support\Arr;

class EditPage extends EditRecord
{
    protected static string $resource = PageResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
        ];
    }

    protected function mutateFormDataBeforeFill(array $data): array
    {
        /** @var Page $page */
        $page = $this->record;
        $data = parent::mutateFormDataBeforeFill($data);

        // Prefill builder blocks for widgets from pivot, preserving sort_order

        return $data;
    }

    protected function afterSave(): void
    {
        /** @var Page $page */
        $page = $this->record;
    }
}
