<?php

namespace App\Filament\Resources\Project;

use App\Filament\Resources\Project\ProjectTypeResource\Pages;
use App\Filament\Resources\Project\ProjectTypeResource\RelationManagers;
use App\Models\Project\ProjectType;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ProjectTypeResource extends Resource
{
    protected static ?string $model = ProjectType::class;

    protected static ?string $navigationGroup = 'Project';
    protected static ?string $navigationLabel = 'Types';
    protected static ?int $navigationSort = 3;


    public static function getPages(): array
    {
        return [
            'index' => Pages\ProjectTypes::route('/'),
        ];
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
