<?php

namespace App\Filament\Resources\Review;

use App\Filament\Resources\Review\ReviewResource\Pages;
// use App\Filament\Resources\Review\ReviewResource\RelationManagers;
use App\Models\Review;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Resources\Review\Trait\ReviewFormTrait;
use App\Filament\Resources\Review\Trait\ReviewTableTrait;

class ReviewResource extends Resource
{
    use ReviewFormTrait;
    use ReviewTableTrait;

    protected static ?string $model = Review::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';



    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListReviews::route('/'),
            'create' => Pages\CreateReview::route('/create'),
            'edit' => Pages\EditReview::route('/{record}/edit'),
        ];
    }
}
