<?php

namespace App\Filament\Resources\Review\ReviewResource\Pages;

use App\Filament\Resources\Review\ReviewResource;
use App\Enums\MemberRatingType;
use App\Enums\MemberType;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditReview extends EditRecord
{
    protected static string $resource = ReviewResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }


    protected function mutateFormDataBeforeSave(array $data): array
    {
        // Extract ratings data
        $ratingsData = [];
        foreach (MemberRatingType::cases() as $ratingType) {
            $key = 'ratings.' . $ratingType->value . '.rating';
            if (isset($data[$key])) {
                $ratingsData[$ratingType->value] = $data[$key];
                unset($data[$key]);
            }
        }

        // Store ratings data to handle after save
        $this->ratingsData = $ratingsData;

        return $data;
    }

    protected function afterSave(): void
    {
        // Update rating records after the review is saved
        if($this->record->ratings()->exists()){
            if (!empty($this->ratingsData)) {
                foreach ($this->ratingsData as $ratingType => $ratingValue) {
                    $this->record->ratings()->updateOrCreate(
                        ['rating_type' => $ratingType],
                        ['rating' => $ratingValue]
                    );
                }
            }
        }
    }

    protected array $ratingsData = [];
}
