<?php

namespace App\Filament\Resources\Review\Trait;

use Filament\Tables\Table;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\TrashedFilter;
use Filament\Tables\Actions\ActionGroup;
use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\DeleteBulkAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\RestoreBulkAction;
use Filament\Tables\Actions\ForceDeleteBulkAction;
use Filament\Tables\Actions\DeleteAction;
use Filament\Tables\Actions\RestoreAction;
use Filament\Tables\Actions\ForceDeleteAction;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Columns\ToggleColumn;
use Filament\Tables\Columns\ViewColumn;
use Filament\Tables\Columns\SpatieMediaLibraryImageColumn;

trait ReviewTableTrait
{
    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                self::reviewableUserAvatarColumn(),
                self::reviewableUserNameColumn(),
                self::reviewTitleColumn(),
                self::reviewStatusColumn(),
                self::reviewCreatedAtColumn(),
                ViewColumn::make('rating')
                    ->view('tables.columns.review-rating'),

            ])
            ->defaultSort('created_at', 'desc')
            ->filters([
                self::trashedFilter(),
            ])
            ->actions([
                self::actionGroup(),
            ])
            ->bulkActions([
                self::bulkActionGroup(),
            ])
            ->modifyQueryUsing(function ($query) {
                return $query->with('reviewable');
            });
    }

    protected static function reviewTitleColumn(): TextColumn
    {
        return TextColumn::make('review_title')
            ->label('Review Title')
            ->sortable()
            ->searchable();
    }

    protected static function reviewableUserAvatarColumn(): ImageColumn
    {
        return SpatieMediaLibraryImageColumn::make('reviewable.avatar')
            ->collection('avatar')
            ->conversion('thumb')
            ->label('Avatar')
            ->grow(false)
            ->circular()
            ->size(40);
    }

    protected static function reviewableUserNameColumn(): TextColumn
    {
        return TextColumn::make('reviewable.name')
            ->label('User')
            ->sortable()
            ->searchable();
    }
    protected static function reviewStatusColumn(): ToggleColumn
    {
        return ToggleColumn::make('status')
            ->label('Status')
            ->sortable()
            ->searchable();
    }

    protected static function reviewCreatedAtColumn(): TextColumn
    {
        return TextColumn::make('created_at')
            ->label('Created At')
            ->sortable()
            ->searchable();
    }

    protected static function reviewUpdatedAtColumn(): TextColumn
    {
        return TextColumn::make('updated_at')
            ->label('Updated At')
            ->sortable()
            ->searchable();
    }

    protected static function reviewDeletedAtColumn(): TextColumn
    {
        return TextColumn::make('deleted_at')
            ->label('Deleted At')
            ->sortable()
            ->searchable();
    }

    protected static function trashedFilter(): TrashedFilter
    {
        return TrashedFilter::make();
    }

    protected static function actionGroup(): ActionGroup
    {
        return ActionGroup::make([
            EditAction::make(),
            DeleteAction::make(),
            RestoreAction::make(),
            ForceDeleteAction::make(),
        ]);
    }

    protected static function bulkActionGroup(): BulkActionGroup
    {
        return BulkActionGroup::make([
            DeleteBulkAction::make(),
            RestoreBulkAction::make(),
            ForceDeleteBulkAction::make(),

        ]);
    }
}
