<?php

namespace App\Filament\Resources\Supplier\SupplierResource\Pages;

use App\Filament\Resources\Supplier\SupplierResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use App\Enums\UserProfileType;
use App\Models\User\MyRole;
use Spatie\Permission\Models\Role;

class CreateSupplier extends CreateRecord
{
    protected static string $resource = SupplierResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        if(!empty($data['profile']['first_name']) && !empty($data['profile']['last_name'])) {
            $data['name'] = $data['profile']['first_name'] . ' ' . $data['profile']['last_name'];
        }
        return $data;
    }

    protected function afterCreate(): void
    {  
        // $this->record->profile()->create($this->data['profile']);

        $profile = $this->data['profile'];
        $profile['profile_type'] = UserProfileType::Business->value;
        $this->record->profile()->create($profile);

        $role = MyRole::where('name' , 'Supplier')->first();
        $this->record->assignRole($role->name);
    }
}
