<?php

namespace App\Filament\Resources\User\RoleResource\Pages;

use App\Filament\Resources\User\RoleResource;
use Filament\Resources\Pages\Page;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Table;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Tables\Columns\TextColumn;
use App\Models\User\MyRole;
use Filament\Tables\Actions\Action;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Select;
use Filament\Forms\Form;
use Filament\Tables\Actions\ActionGroup;
use Filament\Tables\Actions\DeleteAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;
use Filament\Notifications\Notification;

class RolePage extends Page implements HasTable
{
    use InteractsWithForms;
    use InteractsWithTable;

    protected static string $resource = RoleResource::class;

    protected static string $view = 'filament.resources.user.role-resource.pages.role-page';

    public ?array $data = [];

    public $selectedRole = null;

    public function mount(): void
    {
        $this->form->fill();
    }

    public function table(Table $table): Table
    {
        return $table
            ->query(MyRole::query())
            ->columns([
                TextColumn::make('name')
                    ->searchable(),
                TextColumn::make('guard_name')
                    ->searchable(),
            ])
            ->actions([
                ActionGroup::make([
                    // Action::make('edit')
                    //     ->icon('heroicon-m-pencil-square')
                    //     ->action(function (MyRole $record): void {
                    //         $this->selectedRole = $record;
                    //         $this->data = $record->toArray();
                    //     }),
                    // DeleteAction::make()
                    //     ->icon('heroicon-m-trash'),
                ])
                ->tooltip('Actions')
                ->iconButton()
            ])
            ->bulkActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make()
                        ->requiresConfirmation()
                        ->deselectRecordsAfterCompletion()
                ])
            ]);
    }

    public function form(Form $form): Form
    {
        return $form->schema([
            TextInput::make('name')
                ->required()
                ->maxLength(255),
            Select::make('guard_name')
                ->options([
                    'web' => 'Web',
                    'api' => 'API',
                ])
                ->required(),
        ])
        ->statePath('data');
    }

    public function save(): void
    {
        $data = $this->form->getState();

        if ($this->selectedRole) {
            $this->selectedRole->update($data);
            $message = 'Role updated successfully';
        } else {
            MyRole::create($data);
            $message = 'Role created successfully';
        }

        $this->selectedRole = null;
        $this->data = [];
        $this->form->fill();

        Notification::make()
            ->success()
            ->title($message)
            ->send();
    }

    public function cancelEdit(): void
    {
        $this->selectedRole = null;
        $this->data = [];
        $this->form->fill();
    }
}
