<?php

namespace App\Filament\Resources\User\UserResource\Pages;

use App\Filament\Resources\User\UserResource;
use App\Models\User\User;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;

class CreateUser extends CreateRecord
{
    protected static string $resource = UserResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        if(!empty($data['profile']['first_name']) && !empty($data['profile']['last_name'])) {
            $data['name'] = $data['profile']['first_name'] . ' ' . $data['profile']['last_name'];
        }
        return $data;
    }

    protected function afterCreate(): void
    {
        $this->record->profile()->create($this->data['profile']);
    }

}
