<?php

namespace App\Filament\Resources\User\UserResource\Pages;

use App\Filament\Resources\User\UserResource;
use App\Models\User\User;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditUser extends EditRecord
{
    protected static string $resource = UserResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\ViewAction::make()
                ->label('View')
                ->icon('heroicon-o-eye')
                ->color('success'),
            Actions\DeleteAction::make(),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
        ];
    }

    protected function mutateFormDataBeforeFill(array $data): array
    {
        $data['profile'] = $this->record->profile;
        return $data;
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        if(!empty($data['profile']['first_name']) && !empty($data['profile']['last_name'])) {
            $data['name'] = $data['profile']['first_name'] . ' ' . $data['profile']['last_name'];
        }
        return $data;
    }

    protected function afterSave(): void
    {
        $this->record->profile()->updateOrCreate(
            ['user_id' => $this->record->id],
            $this->data['profile']
        );
    }
}
