<?php
namespace App\Filament\TipTapEditor\TiptapBlock;

use FilamentTiptapEditor\TiptapBlock;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Get;

class AdsBlock extends TiptapBlock
{
    public string $preview = 'tiptap-editor.tiptap-blocks.previews.ads-block-preview';
 
    public string $rendered = 'tiptap-editor.tiptap-blocks.rendered.ads-block-render';

    public string $width = 'xl';
 
    public bool $slideOver = true;
 
    public ?string $icon = 'heroicon-o-megaphone';
 
    public function getFormSchema(): array
    {
        return [
            Select::make('template')
                ->label('Template Style')
                ->options([
                    'ad_with_image' => 'Ad with Image',
                    'boxed' => 'Boxed with Dashed Border',
                    'ribbon' => 'Ribbon Badge Style',
                    'compact_image' => 'Compact Image Banner',
                ])
                ->required()
                ->default('ad_with_image')
                ->reactive(),

            // Layout Options - Only for ad_with_image and compact_image
            Select::make('layout')
                ->label('Layout Style')
                ->options([
                    'standard' => 'Standard (Image Left)',
                    'reversed' => 'Reversed (Image Right)',
                ])
                ->hidden(fn (Get $get): bool => $get('template') !== 'ad_with_image')
                ->default('standard')
                ->reactive(),

            // Top Title - For all templates (acts as badge in ribbon, small title in boxed, and badge in ad_with_image)
            TextInput::make('badgetitle')
                ->label(fn (Get $get) => $get('template') === 'ribbon' ? 'Badge Title' : 'Top Title')
                ->placeholder(fn (Get $get) => match ($get('template')) {
                    'ribbon' => 'Home Water Test Kit',
                    'boxed' => 'Call to Action',
                    'ad_with_image' => 'Home Water Test Kit',
                    default => 'Enter top title',
                })
                ->helperText(fn (Get $get) => match ($get('template')) {
                    'ribbon' => 'Appears in the ribbon badge',
                    'boxed' => 'Appears as small title above main title',
                    'ad_with_image' => 'Appears as small title above main title',
                    default => 'Appears above main title',
                })
                ->visible(fn (Get $get) => in_array($get('template'), ['ribbon', 'boxed', 'ad_with_image']))
                ->required(fn (Get $get) => in_array($get('template'), ['ribbon', 'boxed', 'ad_with_image'])),

            // Main Content - Required for all
            TextInput::make('title')
                ->label('Main Title')
                ->placeholder('A Quick and Easy Way to Test Water')
                ->required(),

            // Description - For all templates
            Textarea::make('description')
                ->label('Description')
                ->placeholder('Lead Drinking Water Test Kit for Municipal Tap...')
                ->rows(3)
                ->required(),

            // Media - Only for ad_with_image and compact_image
            FileUpload::make('image')
                ->label('Image')
                ->image()
                ->visible(fn (Get $get) => in_array($get('template'), ['ad_with_image', 'compact_image']))
                ->required(fn (Get $get) => in_array($get('template'), ['ad_with_image', 'compact_image'])),

            // Primary Button - Required for all
            TextInput::make('buttonlabel')
                ->label('Primary Button Label')
                ->placeholder('Purchase Lead Test Kit')
                ->required(),

            TextInput::make('buttonurl')
                ->label('Primary Button URL')
                ->url()
                ->required(),

            Select::make('buttontarget')
                ->label('Primary Button Target')
                ->options([
                    '_self' => 'Same Window',
                    '_blank' => 'New Window',
                ])
                ->default('_self'),

            Select::make('buttoncolor')
                ->label('Primary Button Color')
                ->options([
                    'blue' => 'Blue',
                    'black' => 'Black',
                    'red' => 'Red',
                    'white' => 'White',
                ])
                ->default('blue'),

            Select::make('buttonsize')
                ->label('Primary Button Size')
                ->options([
                    'sm' => 'Small',
                    'md' => 'Medium',
                    'lg' => 'Large',
                ])
                ->default('md'),

            // Secondary Button - Only for boxed and ribbon templates
            TextInput::make('outlinebuttontext')
                ->label('Secondary Button Label')
                ->placeholder('Try Now')
                ->visible(fn (Get $get) => in_array($get('template'), ['boxed', 'ribbon'])),

            TextInput::make('outlinebuttonurl')
                ->label('Secondary Button URL')
                ->url()
                ->visible(fn (Get $get) => in_array($get('template'), ['boxed', 'ribbon']))
                ->required(fn (Get $get, $state) => 
                    in_array($get('template'), ['boxed', 'ribbon']) && 
            !empty($get('outlinebuttontext'))
                ),

            Select::make('outlinebuttontarget')
                ->label('Secondary Button Target')
                ->options([
                    '_self' => 'Same Window',
                    '_blank' => 'New Window',
                ])
                ->default('_self')
                ->visible(fn (Get $get) => in_array($get('template'), ['boxed', 'ribbon'])),

            Select::make('outlinebuttonsize')
                ->label('Secondary Button Size')
                ->options([
                    'sm' => 'Small',
                    'md' => 'Medium',
                    'lg' => 'Large',
                ])
                ->default('md')
                ->visible(fn (Get $get) => in_array($get('template'), ['boxed', 'ribbon'])),

            // Bottom Info - Only for ad_with_image and compact_image
            TextInput::make('bottominfo')
                ->label('Bottom Info Text')
                ->placeholder("Let's embody your beautiful ideas together.")
                ->helperText('Small text that appears at the bottom of the ad'),
        ];
    }
}