<?php
namespace App\Filament\TipTapEditor\TiptapBlock;

use Faker\Core\Color;
use FilamentTiptapEditor\TiptapBlock;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\ColorPicker;

class ButtonBlock extends TiptapBlock
{
    public string $preview = 'tiptap-editor.tiptap-blocks.previews.button-block-preview';
 
    public string $rendered = 'tiptap-editor.tiptap-blocks.rendered.button-block-render';

    public string $width = 'xl';
 
    public bool $slideOver = true;
 
    public ?string $icon = 'heroicon-o-link';
 
    public function getFormSchema(): array
    {
        return [
            TextInput::make('label')
                ->required(),
            Select::make('color')
                ->options([
                    'blue' => 'Blue',
                    'white' => 'White',
                    'red' => 'Red',
                    'black' => 'Black',
                ])
                ->default('blue')
                ->required(),
            Select::make('style')
                ->options([
                    'solid' => 'Solid',
                    'outline' => 'Outline',
                ])
                ->default('solid')
                ->required(),
            Select::make('hovereffect')
                ->options([
                    'reverse' => 'Reverse Colors',
                    'fade' => 'Fade Effect',
                    'slide' => 'Slide Effect',
                    'none' => 'No Effect',
                ])
                ->default('reverse')
                ->required(),
            TextInput::make('url')
                ->label('URL')
                ->required(),
            Select::make('target')
                ->label('Target')
                ->default('_self')
                ->options([
                    '_self' => 'Self',
                    '_blank' => 'Blank',
                ]),
            Select::make('size')
                ->options([
                    'sm' => 'Small',
                    'md' => 'Medium',
                    'lg' => 'Large',
                ])
                ->default('md'),
            Select::make('align')
                ->options([
                    'left' => 'Left',
                    'center' => 'Center',
                    'right' => 'Right',
                ])
                ->default('left'),
        ];
    }
}