<?php

namespace App\Filament\TipTapEditor\TiptapBlock;

use FilamentTiptapEditor\TiptapBlock;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Select;

class ImageWithCaption extends TiptapBlock
{
    public string $preview = 'tiptap-editor.tiptap-blocks.previews.image-with-caption-preview';
    public string $rendered = 'tiptap-editor.tiptap-blocks.rendered.image-with-caption-render';
    public string $width = '2xl';
    public bool $slideOver = true;
    public string $title = 'Image with Caption';
    public ?string $icon = 'heroicon-o-photo';

    public function getFormSchema(): array
    {
        return [
            FileUpload::make('image')
                ->image()
                ->imageEditor()
                ->required()
                ->maxSize(5120) // 5MB
                ->directory('blog-content'),
            TextInput::make('caption')
                ->label('Caption')
                ->required(),
            TextInput::make('alttext')
                ->label('Alt Text')
                ->helperText('Describe the image for accessibility')
                ->required(),
            Select::make('alignment')
                ->options([
                    'left' => 'Left',
                    'center' => 'Center',
                    'right' => 'Right',
                ])
                ->default('center')
                ->required(),
            Select::make('size')
                ->options([
                    'small' => 'Small (25%)',
                    'medium' => 'Medium (50%)',
                    'large' => 'Large (75%)',
                    'full' => 'Full Width (100%)',
                ])
                ->default('medium')
                ->required(),
        ];
    }
} 