<?php

namespace App\Filament\Traits;

use Filament\Forms\Components\Section;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\CheckboxList;

trait HasSeoSection
{
    public static function getSeoSection(): Section
    {
        return Section::make('SEO')
            ->description('SEO settings. If left blank, the title and content will be used.')
            ->relationship('seo')
            ->schema([
                TextInput::make('title')
                    ->label('Meta Title')
                    ->placeholder('Enter the SEO meta title')
                    ->maxLength(70)
                    ->reactive()

                    ->hint(function ($state, TextInput $component) {
                        $length = strlen($state ?? '');
                        return $length > 0 ? "({$length}/{$component->getMaxLength()})" : null;
                    }),

                Textarea::make('description')
                    ->label('Meta Description')
                    ->placeholder('Enter the SEO metadescription')
                    ->maxLength(160)
                    ->reactive()
                    ->hint(function ($state, Textarea $component) {
                        $length = strlen($state ?? '');
                        return $length > 0 ? "({$length}/{$component->getMaxLength()})" : null;
                    }),

                CheckboxList::make('robots')
                    ->label('')
                    ->options([
                        'noindex' => 'No Index - Prevent search engines from indexing this page',
                        'nofollow' => 'No Follow - Prevent search engines from following links on this page',
                    ])
                    ->columns(1)
                    ->afterStateHydrated(function (CheckboxList $component, $state) {
                        if ($state) {
                            $component->state(explode(',', $state));
                        } elseif (!is_array($state)) {
                            $component->state([]);
                        }
                    })
                    ->dehydrateStateUsing(fn($state) => is_array($state) ? implode(',', $state) : null),
            ]);
    }
}
