<?php

namespace App\Forms\Components;

use Filament\Forms\Components\Field;
use Filament\Forms\Components\Concerns;
use Illuminate\Support\Str;

class TinyMceEditor extends Field
{
    use Concerns\CanBeLengthConstrained;
    use Concerns\HasPlaceholder;
    
    protected string $view = 'forms.components.tiny-mce-editor';
    
    protected array | string | null $plugins = 'lists link autolink autoresize';
    
    protected array | string | null $toolbar = 'undo redo | formatselect | h2 h3 h4 | bold italic underline | bullist numlist | link';
    
    protected int $height = 300;
    
    protected bool $menubar = false;
    
    protected bool $branding = false;
    
    protected bool $promotion = false;
    
    protected string | null $editorId = null;
    
    protected function setUp(): void
    {
        parent::setUp();
        
        $this->editorId = 'tinymce-' . Str::random(10);
    }
    
    public function getEditorId(): string
    {
        return $this->editorId;
    }
    
    public function plugins(string | array $plugins): static
    {
        $this->plugins = $plugins;
        
        return $this;
    }
    
    public function getPlugins(): string
    {
        if (is_array($this->plugins)) {
            return implode(' ', $this->plugins);
        }
        
        return $this->plugins;
    }
    
    public function toolbar(string | array $toolbar): static
    {
        $this->toolbar = $toolbar;
        
        return $this;
    }
    
    public function getToolbar(): string
    {
        if (is_array($this->toolbar)) {
            return implode(' | ', $this->toolbar);
        }
        
        return $this->toolbar;
    }
    
    public function height(int $height): static
    {
        $this->height = $height;
        
        return $this;
    }
    
    public function getHeight(): int
    {
        return $this->height;
    }
    
    public function menubar(bool $menubar): static
    {
        $this->menubar = $menubar;
        
        return $this;
    }
    
    public function getMenubar(): bool
    {
        return $this->menubar;
    }
    
    public function branding(bool $branding): static
    {
        $this->branding = $branding;
        
        return $this;
    }
    
    public function getBranding(): bool
    {
        return $this->branding;
    }
    
    public function promotion(bool $promotion): static
    {
        $this->promotion = $promotion;
        
        return $this;
    }
    
    public function getPromotion(): bool
    {
        return $this->promotion;
    }
} 