<?php

use App\Enums\JobShift;
use App\Enums\ClassifiedCondition;

define('ESP_ROLE_MEMBER', 'Service');
define('ESP_ROLE_ADMIN', 'Admin');
define('ESP_ROLE_SUPER_ADMIN', 'Super Admin');
define('ESP_ROLE_SUBSCRIBER', 'Subscriber');
define('ESP_ROLE_SUPPLIER', 'Supplier');
define('ESP_ROLE_MANUFACTURER', 'Manufacturer');

if (!function_exists('esp_get_job_working_shifts')) {
    function esp_get_job_working_shifts()
    {
        $shifts = JobShift::cases();
        return $shifts;
    }
}

if (!function_exists('esp_get_classified_condition_list')) {
    function esp_get_classified_condition_list()
    {        
        $classifiedConditions = ClassifiedCondition::cases();
        return $classifiedConditions;
    }
}

if (!function_exists('esp_get_date_range')) {
    function esp_get_date_range($input, $endDate = null)
    {
        if (is_numeric($input)) {
            // Handle number of days case - from now back X days
            $endDate = now();
            $startDate = now()->subDays($input);
            return [
                'start_date' => $startDate,
                'end_date' => $endDate
            ];
        } else {
            // Handle custom date range case
            return [
                'start_date' => $input, // This would be the startDate
                'end_date' => $endDate
            ];
        }
    }
}
