<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Services\ActionHandlerService;
use Exception;
use Illuminate\Support\Facades\Log;

class AjaxController extends Controller
{

    protected $actionHandler;

    public function __construct(ActionHandlerService $actionHandler)
    {
        $this->actionHandler = $actionHandler;
    }

    public function handle(Request $request): JsonResponse
    {
        try {
            // Validate required parameters
            $request->validate([
                'action' => 'required|string',
                'module' => 'required|string',
                'model_id' => 'required|string',
            ]);

            $action = $request->input('action');
            $module = $request->input('module');
            $modelId = $request->input('model_id');
            $additionalData = $request->except(['action', 'module', 'model_id']);

            // Handle the action
            $result = $this->actionHandler->handleAction($action, $module, $modelId, $additionalData);

            return response()->json([
                'success' => true,
                'message' => $result['message'] ?? 'Action completed successfully',
                'data' => $result['data'] ?? null,
            ]);
        } catch (\Illuminate\Validation\ValidationException $e) {
            return response()->json([
                'success' => false,
                'message' => 'Validation failed',
                'errors' => $e->errors(),
            ], 422);
        } catch (Exception $e) {
            Log::error('Centralized Action Error: ' . $e->getMessage(), [
                'action' => $request->input('action'),
                'module' => $request->input('module'),
                'model_id' => $request->input('model_id'),
                'trace' => $e->getTraceAsString()
            ]);

            return response()->json([
                'success' => false,
                'message' => 'An error occurred while processing your request' . $e->getMessage(),
            ], 500);
        }
    }
}
