<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Traits\ApiResponseTrait;

class ApiController extends Controller
{
    use ApiResponseTrait;

    /**
     * Items per page for pagination
     */
    protected int $perPage = 15;

    /**
     * Get pagination limit from request
     */
    protected function getPaginationLimit(): int
    {
        $perPage = request()->get('per_page', $this->perPage);

        // Limit to max 100 items per page
        return min((int) $perPage, 100);
    }

    /**
     * Check if request wants to include relationships
     */
    protected function wantsRelationships(string $relationship): bool
    {
        $includes = request()->get('include', '');
        $includesArray = array_map('trim', explode(',', $includes));

        return in_array($relationship, $includesArray);
    }

    /**
     * Get requested relationships
     */
    protected function getRequestedRelationships(): array
    {
        $includes = request()->get('include', '');

        if (empty($includes)) {
            return [];
        }

        return array_map('trim', explode(',', $includes));
    }
}
