<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\Purchase\PurchaseService;
use Barryvdh\DomPDF\Facade\Pdf;
class InvoiceController extends Controller
{
    public function __construct(private PurchaseService $purchaseService){}
    public function generateInvoice(string $uuid){
        $invoice = $this->purchaseService->findByUuid($uuid);
        $pdf = Pdf::loadView('dashboard.pdfs.print-pdf', [
            'invoice' => $invoice
        ]);
        return $pdf->download('dashboard.pdfs.print-pdf');
    }
}
