<?php

namespace App\Http\Controllers\Frontend\Classified;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\Classified\ClassifiedService;
use App\Services\User\UserService;

class ClassifiedController extends Controller
{
    protected $classifiedService;
    protected $userService;
    public function __construct(ClassifiedService $classifiedService, UserService $userService)
    {
        $this->classifiedService = $classifiedService;
        $this->userService = $userService;
    }

    public function index(Request $request)
    {
        // Get page data shared from pageSeoMiddleware
        $page = $request->attributes->get('page');
        $seoData = $request->attributes->get('seoData');
        
        $data = [];

        if ($page) {
            $data = $page->data;
        }
        $breadcrumbs = [
            'name' => 'classifieds',
            'params' => [],
        ];
        return view('classified.classified-list', compact('breadcrumbs', 'data', 'seoData', 'page'));
    }

    public function show($slug)
    {
        $classified = $this->classifiedService->findBySlug($slug);
        $user = $classified->user;
        if (!$classified) {
            abort(404);
        }
        $reviewsStats = $this->userService->getUserReviewsStats($user->id);

        $breadcrumbs = ['name' => 'classified-detail', 'params' => ['classified' => $classified]];

        return view('classified.classified-detail', compact('classified', 'breadcrumbs', 'user', 'reviewsStats'));
    }
}
