<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\NewsletterSubscriber;
use Illuminate\Http\Request;
use Illuminate\View\View;
use RalphJSmit\Laravel\SEO\Support\SEOData;
use SnipifyDev\LaravelCaptcha\Rules\Recaptcha;
use SnipifyDev\LaravelCaptcha\Rules\RecaptchaValidationRule;

class ComingSoonController extends Controller
{
    /**
     * Display the coming soon page.
     */
    public function index(): View
    {
        $seoData = new SEOData(
            title: 'Coming Soon | ' . config('app.name'),
            description: 'Our website is under construction. We\'re working hard to bring you a great experience. Stay tuned!',
            canonical_url: url('/')
        );

        return view('welcome', [
            'seoData' => $seoData
        ]);
    }

    /**
     * Handle the notify me form submission.
     */
    public function notifyMe(Request $request)
    {
        // Validate email
        $request->validate([
            'email' => 'required|email|unique:newsletter_subscribers,email|max:255',
            'captchaToken' => ['required', new RecaptchaValidationRule('notify_me', null, 'v3')],
        ]);

        // Create a new newsletter subscriber
        NewsletterSubscriber::create([
            'email' => $request->email,
        ]);

        return back()->with('success', 'Thank you! We will notify you when we launch.');
    }
}
