<?php

namespace App\Http\Controllers\Frontend\Eqiupment;

use App\Http\Controllers\Controller;
use App\Services\Equipment\EquipmentService;
use Illuminate\View\View;
use App\Services\User\UserService;

class EquipmentController extends Controller
{
    protected $equipmentService;
    protected $userService;

    public function __construct(EquipmentService $equipmentService, UserService $userService)
    {
        $this->equipmentService = $equipmentService;
        $this->userService = $userService;
    }

    public function show(string $slug): View
    {
        $equipment = $this->equipmentService->findBySlug($slug);
        if (!$equipment) {
            abort(404);
        }
        $user = $equipment->user;
        $reviewsStats = $this->userService->getUserReviewsStats($user->id);
        $breadcrumbs = ['name' => 'equipment-detail', 'params' => ['equipment' => $equipment]];

        return view('equipment.equipment-detail', compact('equipment', 'breadcrumbs', 'reviewsStats'));
    }
}
