<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use RalphJSmit\Laravel\SEO\Support\SEOData;

class HomeController extends Controller
{
    public function index()
    {
        $seoData = new SEOData(
            title: 'Home - Earth Services Pro',
            description: 'Earth Services Pro',
        );
        return view('welcome', compact('seoData'));
    }

    public function notifyMe(Request $request)
    {
        // Manual captcha validation for regular form
        $captchaRule = new Recaptcha('notify_me', null, 'v3');
        $captchaError = null;
        $captchaRule->validate('captchaToken', $request->input('captchaToken'), function($message) use (&$captchaError) {
            $captchaError = $message;
        });

        if ($captchaError) {
            return back()->withErrors(['captchaToken' => $captchaError])->withInput();
        }

        // Validate email
        $request->validate([
            'email' => 'required|email|max:255',
        ]);

        // For now, just return success message
        return back()->with('success', 'Thank you! We will notify you when we launch.');
    }
}
