<?php

namespace App\Http\Controllers\Frontend\Job;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\View\View;
use App\Services\Job\JobService;
use App\Services\User\UserService;

class JobController extends Controller
{
    protected $jobService;
    protected $userServivce;
    public function __construct(JobService $jobService, UserService $userServivce)
    {
        $this->jobService = $jobService;
        $this->userServivce = $userServivce;
    }

    public function index(Request $request): View
    {
        // Get page data shared from pageSeoMiddleware
        $page = $request->attributes->get('page');
        $seoData = $request->attributes->get('seoData');
        $data = [];

        $breadcrumbs = [
            'name' => 'job-list',
            'params' => [],
        ];

        return view('job.job-list', compact('breadcrumbs', 'data', 'seoData', 'page'));
    }

    public function show(string $slug): View
    {
        $job = $this->jobService->findBySlug($slug);

        $user = $job->user;

        if (!$job) {
            abort(404);
        }

        $reviewsStats = $this->userServivce->getUserReviewsStats($user->id);

        $breadcrumbs = ['name' => 'job-detail', 'params' => ['job' => $job]];

        return view('job.show', compact('job', 'breadcrumbs', 'reviewsStats'));
    }

    public function apply(string $slug): View
    {
        $job = $this->jobService->findBySlug($slug);
        if (! $job) {
            abort(404);
        }
        $breadcrumbs = [
            'name' => 'job-apply',
            'params' => ['title' => $job->job_title, 'member' => $job?->author, 'jobTitle' => $job->job_title],
        ];
        return view('job.apply', compact('job', 'breadcrumbs'));
    }
}
