<?php

namespace App\Http\Controllers\Frontend\Lead;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\Lead\LeadService;
class LeadController extends Controller
{
    protected $leadService;

    public  function __construct(LeadService $leadService){
        $this->leadService = $leadService;
    }
    public function LeadForm(Request $request){

        $page = $request->attributes->get('page');

        // Capture location data from URL parameters
        $locationData = [
            'address' => $request->query('address'),
            'lat' => $request->query('lat'),
            'lng' => $request->query('lng'),
            'city' => $request->query('city'),
            'state' => $request->query('state'),
            'state_code' => $request->query('state_code'),
            'country' => $request->query('country'),
            'country_code' => $request->query('country_code'),
        ];

        return view('leads.lead-form', [
            'page' => $page,
            'locationData' => $locationData,
        ]);
    }

    public function LeadSummary($uuid){
        $lead = $this->leadService->findByUuid($uuid);
        return view('leads.lead-summary', [
            'lead' => $lead,
        ]);
    }
}
