<?php

namespace App\Http\Controllers\Frontend\Project;

use App\Http\Controllers\Controller;
use App\Services\Project\ProjectService;
use RalphJSmit\Laravel\SEO\Support\SEOData;
use App\Services\User\UserService;

class ProjectController extends Controller
{
    protected $projectService;
    protected $userServivce;
    public function __construct(ProjectService $projectService, UserService $userServivce)
    {
        $this->projectService = $projectService;
        $this->userServivce = $userServivce;
    }

    public function show(string $slug)
    {
        $project = $this->projectService->findBySlug($slug);
        $user = $project->user;
        $reviewsStats = $this->userServivce->getUserReviewsStats($user->id);
        $seoData = new SEOData(
            title: $project->name . ' - Earth Services Pro',
            description: $project->description,
        );
        $breadcrumbs = [
            'name' => 'project',
            'params' => ['project' => $project],
        ];
        return view('project.project-detail', compact('project', 'seoData', 'breadcrumbs', 'reviewsStats'));
    }
}
