<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Page;
use Diglactic\Breadcrumbs\Breadcrumbs;
use App\Enums\PageStatus;
use App\Enums\PageTypeEnum;

class TemplateController extends Controller
{
    public function index($slug)
    {
        // dd($slug);
        $page = Page::where('slug', $slug)->where('status', PageStatus::Published)->where('page_type', PageTypeEnum::Page)->first();
        if (!$page) {
            abort(404);
        }
        $templateClass = $page->template;
        $view = $templateClass::$view;
        $data = $page->data;

        // Generate breadcrumbs
        return view($view, [
            'page' => $page,
            'data' => $data,
        ]);
    }
}
