<?php
namespace App\Http;

use Illuminate\Foundation\Http\Kernel as HttpKernel;

class Kernel extends HttpKernel
{
    /**
     * The application's global HTTP middleware stack.
     *
     * These middleware are run during every request to your application.
     *
     * @var array<int, class-string|string>
     */
    protected $middleware = [
        \App\Http\Middleware\ThemeLoader::class,
        \App\Http\Middleware\PageSeoMiddleware::class,
    ];

    /**
     * The application's route middleware groups.
     *
     * @var array<string, array<int, class-string|string>>
     */
    protected $middlewareGroups = [
        'web' => [
            // ... your web middleware
        ],
        'api' => [
            // ... your api middleware
        ],
    ];

    /**
     * The application's route middleware.
     *
     * These middleware may be assigned to groups or used individually.
     *
     * @var array<string, class-string|string>
     */
    protected $routeMiddleware = [
        'theme' => \Hexadog\ThemesManager\Http\Middleware\ThemeLoader::class,   
        'pageseo' => \App\Http\Middleware\PageSeoMiddleware::class,
        'preview' => \App\Http\Middleware\PreviewMiddleware::class,
    ];
}
