<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\View;
use App\Models\Page;
use RalphJSmit\Laravel\SEO\Support\SEOData;

class PageSeoMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $seoData = new SEOData(
            title: 'Blog - Earth Services Pro',
            description: 'Earth Services Pro',
        );

        // Custom SEO data for specific routes
        $routeName = $request->route()->getName();

        $page = Page::where('route_name', $routeName)->first();
        if ($page) {
            $seoData = $page->seo;
        }
        $request->attributes->set('page', $page);
        $request->attributes->set('seoData', $seoData);
        return $next($request);
    }
}
