<?php

namespace App\Http\Middleware;

use Closure;
use Hexadog\ThemesManager\Http\Middleware\ThemeLoader as HexadogThemeLoader;

class ThemeLoader extends HexadogThemeLoader
{
    public function handle($request, Closure $next, $theme = 'esp_blue')
    {
        // Skip theme loading for Livewire requests
        if ($request->hasHeader('X-Livewire')) {
            return $next($request);
        }

        return parent::handle($request, $next, $theme);
    }
}
