<?php

namespace App\Http\Middleware;

use App\Models\Lead\LeadForm;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ValidateLeadFormAccess
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $uuid = $request->route('uuid');

        if (!$uuid) {
            return response()->json([
                'success' => false,
                'message' => 'Lead form identifier is required',
                'error_code' => 'INVALID_UUID',
                'errors' => null,
                'meta' => null,
            ], 400);
        }

        try {
            $leadForm = LeadForm::where('uuid', $uuid)->firstOrFail();

            // Check if form is active for public endpoints
            if (!$request->user() && !$leadForm->is_active) {
                return response()->json([
                    'success' => false,
                    'message' => 'This lead form is currently inactive',
                    'error_code' => 'FORM_INACTIVE',
                    'errors' => null,
                    'meta' => null,
                ], 403);
            }

            // Attach lead form to request for later use
            $request->attributes->set('lead_form', $leadForm);

            return $next($request);

        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException) {
            return response()->json([
                'success' => false,
                'message' => 'Lead form not found',
                'error_code' => 'FORM_NOT_FOUND',
                'errors' => null,
                'meta' => null,
            ], 404);
        }
    }
}
