<?php

namespace App\Http\Resources\V1\Lead\Lead;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class LeadResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->uuid,
            'lead_form_id' => $this->leadForm?->uuid,
            'lead_source' => $this->lead_source,
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'full_name' => trim(($this->first_name ?? '') . ' ' . ($this->last_name ?? '')),
            'email' => $this->email,
            'phone' => $this->phone,
            'message' => $this->message,
            'lead_status' => $this->lead_status?->value,
            'created_at' => $this->created_at?->toIso8601String(),
            'updated_at' => $this->updated_at?->toIso8601String(),

            // Conditional relationships
            'lead_form' => $this->when($this->relationLoaded('leadForm'), function () {
                return [
                    'id' => $this->leadForm->uuid,
                    'title' => $this->leadForm->title,
                ];
            }),

            'author' => $this->when($this->relationLoaded('author'), function () {
                return [
                    'id' => $this->author->id,
                    'name' => $this->author->name,
                    'email' => $this->author->email,
                ];
            }),
        ];
    }
}
