<?php

namespace App\Http\Resources\V1\Lead\LeadForm;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class LeadFormResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->uuid,
            'title' => $this->title,
            'description' => $this->description,
            'match_criteria' => $this->match_criteria?->value,
            'reception_mode' => $this->reception_mode?->value,
            'enable_captcha' => $this->enable_captcha,
            'is_active' => $this->is_active,
            'submit_message' => $this->submit_message,
            'created_at' => $this->created_at?->toIso8601String(),
            'updated_at' => $this->updated_at?->toIso8601String(),

            // Conditional relationships
            'author' => $this->when($this->relationLoaded('author'), function () {
                return [
                    'id' => $this->author->id,
                    'name' => $this->author->name,
                    'email' => $this->author->email,
                ];
            }),
        ];
    }
}
