<?php

namespace App\Http\Resources\V1\Lead\LeadFormVisit;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class LeadFormVisitResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->uuid,
            'lead_form_id' => $this->leadForm?->uuid,
            'source' => $this->source,
            'unique_identifier' => $this->unique_identifier,
            'ip_address' => $this->ip_address,
            'location' => [
                'country' => $this->country,
                'state' => $this->state,
                'city' => $this->city,
                'full_location' => $this->getFullLocation(),
            ],
            'visit_date' => $this->visit_date,

            // Lead form
            'lead_form' => $this->when($this->relationLoaded('leadForm'), function () {
                return [
                    'id' => $this->leadForm->uuid,
                    'title' => $this->leadForm->title,
                ];
            }),
        ];
    }

    /**
     * Get full location string
     */
    private function getFullLocation(): ?string
    {
        $parts = array_filter([
            $this->city,
            $this->state,
            $this->country,
        ]);

        return !empty($parts) ? implode(', ', $parts) : null;
    }
}
