<?php

namespace App\Http\Resources\V1\Lead\LeadFormVisit;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class LeadFormVisitStatsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'total_visits' => $this->resource['total_visits'] ?? 0,
            'unique_visitors' => $this->resource['unique_visitors'] ?? 0,
            'visits_by_source' => $this->resource['visits_by_source'] ?? [],
            'visits_by_country' => $this->resource['visits_by_country'] ?? [],
            'visits_by_date' => $this->resource['visits_by_date'] ?? [],
            'conversion_rate' => $this->resource['conversion_rate'] ?? 0,
        ];
    }
}
