<?php

namespace App\Listeners;

use App\Events\ContactUs;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Services\User\UserService;
use App\Notifications\UserMessageRecived;

class SendContactUsNotification implements ShouldQueue
{
    use InteractsWithQueue;
    protected $userService;
    /**
     * Create the event listener.
     */
    public function __construct(UserService $userService)
    {
        $this->userService = $userService;
    }

    /**
     * Handle the event.
     */
    public function handle(ContactUs $event): void
    {
        // dump($event);

        $data = $event->data;
        // Find the recipient user
        $recipient = $this->userService->find($data['recipient_id']);
        
        if ($recipient) {
            // Send notification to the recipient
            $recipient->notify(new UserMessageRecived([
                'name' => $data['name'],
                'email' => $data['email'],
                'phone' => $data['phone'],
                'message' => $data['message'],
                'recipient_name' => $recipient->name,
            ]));
        }
    }

}
