<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Support\Facades\Validator;

class ComingSoonSubscription extends Component
{
    public string $email = '';
    public bool $subscribed = false;
    public string $errorMessage = '';
    
    public function subscribe()
    {
        $validator = Validator::make(
            ['email' => $this->email],
            ['email' => 'required|email']
        );
        
        if ($validator->fails()) {
            $this->errorMessage = $validator->errors()->first('email');
            return;
        }
        
        // Here you would typically store the email in a database
        // For example:
        // DB::table('subscribers')->insert(['email' => $this->email, 'created_at' => now()]);
        
        // For now, we'll just set the subscribed flag to true
        $this->errorMessage = '';
        $this->subscribed = true;
    }
    
    public function render()
    {
        return view('livewire.coming-soon-subscription');
    }
}
