<?php

namespace App\Livewire\Dashboard\Applicants;

use App\Models\Job\JobApplication;
use App\Services\Job\JobApplicationService;
use Livewire\Component;
use Livewire\Attributes\Url;
use Livewire\Attributes\Layout;
use Illuminate\Support\Facades\Auth;

#[Layout('layouts.dashboard.dashboard-app')]
class ViewApplicants extends Component
{
    #[Url]
    public $uuid;

    public $jobApplication;

    protected JobApplicationService $jobApplicationService;

    public function boot(JobApplicationService $jobApplicationService)
    {
        $this->jobApplicationService = $jobApplicationService;
    }

    public function mount($uuid)
    {
        $this->uuid = $uuid;
        $this->loadJobApplication();
    }

    public function loadJobApplication()
    {
        // Find the job application with all necessary relationships
        $this->jobApplication = JobApplication::with([
            'applicant',
            'job' => function ($query) {
                $query->with([
                    'job_role',
                    'job_industry',
                    'job_type',
                    'job_career_level',
                    'currency',
                    'country',
                    'state',
                    'city',
                    'user'
                ]);
            }
        ])->where('uuid', $this->uuid)->first();
        
        if (!$this->jobApplication) {
            abort(404, 'Job application not found');
        }


    }
    public function updateStatus($id, $status)
    {
        try {
            $this->jobApplicationService->updateStatus($id, $status);
            $this->dispatch('success', message: __('Application status updated successfully'));
        } catch (\Exception $e) {
            $this->dispatch('error', message: __('Failed to update application status'));
        }
        $this->loadJobApplication();
    }
    public function back()
    {
        return redirect()->route('dashboard.job.application');
    }

    public function downloadResume()
    {
        if ($this->jobApplication && $this->jobApplication->hasMedia('resume')) {
            $resumeFile = $this->jobApplication->getFirstMedia('resume');
            return response()->download($resumeFile->getPath(), $resumeFile->name);
        }
        
        session()->flash('error', 'Resume not found');
    }

    public function render()
    {
        return view('livewire.dashboard.applicants.view-applicants');
    }
}
