<?php

namespace App\Livewire\Dashboard\Classified;

use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Illuminate\Contracts\View\View;
use App\Services\Classified\ClassifiedService;
use Illuminate\Database\Eloquent\Builder;
use Livewire\Component;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Locked;
use Filament\Support\Enums\MaxWidth;
use Filament\Tables\Actions\Action;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;
use Filament\Tables\Actions\ForceDeleteBulkAction;
use Filament\Tables\Actions\RestoreBulkAction;
use App\Filament\Dashboard\Classified\ClassifiedTable;
use Illuminate\Support\Facades\Auth;

#[Layout('layouts.dashboard.dashboard-app')]
class ClassifiedList extends Component implements HasForms, HasTable
{
    use InteractsWithForms;
    use InteractsWithTable;

    #[Locked]
    protected $classifiedService;

    public function boot(ClassifiedService $classifiedService)
    {
        $this->classifiedService = $classifiedService;
    }

    public function table(Table $table): Table
    {
        return $table
            ->query($this->query())
            ->columns(
                (new ClassifiedTable())->getTable()
            )
            ->filters(
                (new ClassifiedTable())->getFilters()
            )
            ->filtersFormColumns(2)
            ->filtersFormWidth(MaxWidth::Medium)
            ->filtersTriggerAction(
                fn(Action $action) => $action
                    ->button()
                    ->label('Filters'),
            )
            ->actions(
                (new ClassifiedTable())->getActions()
            )
            ->bulkActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                    ForceDeleteBulkAction::make(),
                    RestoreBulkAction::make(),
                ]),
            ])
            ->paginated([10, 25, 50, 100])
            ->defaultPaginationPageOption(25)
            ->deferLoading()
            ->defaultSort('created_at', 'desc');
    }

    public function query(): Builder
    {
        $args = [
            'user_id' => Auth::id(),
        ];
        return $this->classifiedService->getAll($args);
    }
    public function render() : View
    {
        return view('livewire.dashboard.classified.classified-list');
    }
}
