<?php

namespace App\Livewire\Dashboard\Equipment;

use Livewire\Component;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Illuminate\Contracts\View\View;
use App\Services\Equipment\EquipmentService;
use Illuminate\Database\Eloquent\Builder;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Locked;
use Filament\Support\Enums\MaxWidth;
use Filament\Tables\Actions\Action;
use App\Filament\Dashboard\Equipment\EquipmentTable;
use Illuminate\Support\Facades\Auth;

#[Layout('layouts.dashboard.dashboard-app')]
class ListEquipment extends Component implements HasForms, HasTable
{
    use InteractsWithForms;
    use InteractsWithTable;

    #[Locked]
    protected $equipmentService;

    public function boot(EquipmentService $equipmentService)
    {
        $this->equipmentService = $equipmentService;
    }


    public function table(Table $table): Table
    {
        return $table
            ->query($this->query())
            ->columns(
                (new EquipmentTable())->getTable()
            )
            ->filters(
                (new EquipmentTable())->getFilters()
            )
            ->filtersFormColumns(1)
            ->filtersFormWidth(MaxWidth::Large)
            ->filtersTriggerAction(
                fn(Action $action) => $action
                    ->button()
                    ->label('Filters'),
            )
            ->actions(
                (new EquipmentTable())->getActions()
            )
            ->bulkActions(
                (new EquipmentTable())->getBulkActions()
            )
            ->paginated([10, 25, 50, 100])
            ->defaultPaginationPageOption(25)
            ->deferLoading()
            ->defaultSort('created_at', 'desc');
    }

    public function query(): Builder
    {
        $args = [
            'user_id' => Auth::id(),
        ];
        return $this->equipmentService->getAll($args);
    }

    public function render(): View
    {
        return view('livewire.dashboard.equipment.list-equipment');
    }
}
