<?php

namespace App\Livewire\Dashboard\Favourite;

use App\Services\User\UserFavoriteService;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Livewire\Attributes\Layout;
use Livewire\WithPagination;

#[Layout('layouts.dashboard.dashboard-app')]
class UserFavorite extends Component
{
    use WithPagination;

    public string $activeTab = 'classified';
    public array $favoriteTypes = [];
    protected $userFavoriteService;

    public function boot(UserFavoriteService $userFavoriteService)
    {
        $this->userFavoriteService = $userFavoriteService;
    }

    public function mount()
    {
        $this->loadFavoriteTypes();
    }

    public function loadFavoriteTypes()
    {
        $this->favoriteTypes = $this->userFavoriteService->getFavoritesByType(Auth::id());
    }

    public function setActiveTab(string $tab)
    {
        $this->activeTab = $tab;
        $this->resetPage();
    }

    public function removeFavorite(int $modelId)
    {
        $modelTypes = [
            'post' => 'App\\Models\\Blog\\Post',
            'classified' => 'App\\Models\\Classified\\Classified',
            'job' => 'App\\Models\\Job\\Job',
            'equipment' => 'App\\Models\\Equipment\\Equipment',
            'users' => 'App\\Models\\User\\User',
            'project' => 'App\\Models\\Project\\Project',
            'product' => 'App\\Models\\Product\\Product',
        ];

        $modelType = $modelTypes[$this->activeTab] ?? null;

        if ($modelType) {
            $removed = $this->userFavoriteService->removeFavorite(Auth::id(), $modelType, $modelId);
            
            if ($removed) {
                session()->flash('message', 'Item removed from favourites successfully.');
                $this->loadFavoriteTypes();
            } else {
                session()->flash('error', 'Failed to remove item from favourites.');
            }
        }
    }

    public function getFavoritesProperty()
    {
        $modelTypes = [
            'post' => 'App\\Models\\Blog\\Post',
            'classified' => 'App\\Models\\Classified\\Classified',
            'job' => 'App\\Models\\Job\\Job',
            'equipment' => 'App\\Models\\Equipment\\Equipment',
            'users' => 'App\\Models\\User\\User',
            'project' => 'App\\Models\\Project\\Project',
            'product' => 'App\\Models\\Product\\Product',
        ];

        $modelType = $modelTypes[$this->activeTab] ?? null;

        if (!$modelType) {
            return collect();
        }

        return $this->userFavoriteService->getUserFavoritesPaginated(
            Auth::id(), 
            $modelType, 
            15
        );
    }

    public function render()
    {
        return view('livewire.dashboard.favourite.user-favorite', [
            'favorites' => $this->favorites,
            'favoriteTypes' => $this->favoriteTypes,
        ]);
    }
}