<?php

namespace App\Livewire\Dashboard\LeadInquiries;

use Livewire\Attributes\Layout;
use Livewire\Component;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Filament\Tables\Columns\TextColumn;
use App\Services\Inquiry\InquiryService;
use Illuminate\Support\Facades\Auth;
use Filament\Tables\Actions\Action;
use Filament\Tables\Actions\ActionGroup;
use App\Models\User\Inquiry;
use Filament\Tables\Actions\BulkAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Filters\SelectFilter;
use App\Enums\InquiryStatus;
use App\Enums\InquiryType;
use Filament\Tables\Filters\TrashedFilter;
use Illuminate\Database\Eloquent\Builder;

#[Layout('layouts.dashboard.dashboard-app')]
class LeadInquiries extends Component implements HasForms, HasTable
{
    use InteractsWithForms;
    use InteractsWithTable;

    protected $inquiryService;

    public function boot(InquiryService $inquiryService)
    {
        $this->inquiryService = $inquiryService;
    }

    public function mount()
    {
        $this->getInquiries();
    }

    public function getInquiries()
    {
        $args = [
            'user_id' => Auth::user()->id,
        ];

        return $this->inquiryService->getAll($args);
    }

    public function table(Table $table)
    {
        return $table
            ->query($this->getInquiries())
            ->columns([
                TextColumn::make('contact.first_name')
                    ->searchable()
                    ->sortable()
                    ->label(__('Name'))
                    ->getStateUsing(function ($record) {
                        $name = $record->contact->first_name ?? 'N/A';
                        return $name;
                    }),
                TextColumn::make('contact.email')
                    ->searchable()
                    ->sortable()
                    ->label(__('Email'))
                    ->getStateUsing(function ($record) {
                        $email = $record->contact->email ?? 'N/A';
                        return $email;
                    }),
                TextColumn::make('contact.phone')
                    ->searchable()
                    ->sortable()
                    ->label(__('Phone'))
                    ->getStateUsing(function ($record) {
                        $phone = $record->contact->phone ?? 'N/A';

                        return $phone;
                    }),
                TextColumn::make("inquiry_type")
                    ->sortable()
                    ->label(__('Type'))
                    ->badge(),
                TextColumn::make("inquiry_status")
                    ->sortable()
                    ->label(__('Status'))
                    ->badge(),
                TextColumn::make("created_at")
                    ->sortable()
                    ->label(__('Date'))
                    ->dateTime('M D, Y'),

            ])
            ->defaultSort('created_at', 'desc')
            ->filters([
                SelectFilter::make('inquiry_status')
                    ->label(__('Status'))
                    ->options(InquiryStatus::class),
                SelectFilter::make('inquiry_type')
                    ->label(__('Type'))
                    ->options(InquiryType::class),
            ])
            ->actions([
                ActionGroup::make([
                    // Action::make('view')
                    //     ->label(__('View'))
                    //     ->icon('heroicon-o-eye')
                    //     ->color('primary')
                    //     ->url(function (Inquiry $record) {
                    //         return route('dashboard.inquiry.show',['uuid' => $record->uuid]);
                    //     }),
                    Action::make('delete')
                        ->label(__('Delete'))
                        ->color('danger')
                        ->icon('heroicon-o-trash')
                        ->requiresConfirmation(),
                ])

            ])
            ->bulkActions([
                BulkActionGroup::make([
                    BulkAction::make('delete')
                        ->label(__('Delete'))
                        ->color('danger')
                        ->icon('heroicon-o-trash')
                        ->requiresConfirmation()
                ])
            ]);
    }

    public function render()
    {
        return view('livewire.dashboard.lead-inquiries.lead-inquiries');
    }
}
