<?php

namespace App\Livewire\Dashboard\LeadInquiries;

use App\Services\Inquiry\InquiryService;
use App\Enums\InquiryStatus;
use Livewire\Component;
use Livewire\Attributes\Layout;


#[Layout('layouts.dashboard.dashboard-app')]
class LeadInquiryView extends Component
{
    protected $inquiryService;


    public $uuid;
    public $inquiry;

    public function boot(InquiryService $inquiryService)
    {
        $this->inquiryService = $inquiryService;
    }

    public function mount($uuid)
    {
        $this->uuid = $uuid;
        $this->getInquiry();
    }

    public function getInquiry()
    {
        $this->inquiry = $this->inquiryService->findByUuid($this->uuid);
        
        if (!$this->inquiry) {
            abort(404, 'Inquiry not found');
        }
    }

    public function markAsContacted()
    {
        try {
            if ($this->inquiry && $this->inquiry->inquiry_status === InquiryStatus::Pending) {
                $updated = $this->inquiryService->update($this->inquiry, [
                    'inquiry_status' => InquiryStatus::Contacted
                ]);

                if ($updated) {
                    $this->getInquiry(); // Refresh the inquiry data
                    session()->flash('success', 'Inquiry marked as contacted successfully.');
                } else {
                    session()->flash('error', 'Failed to update inquiry status.');
                }
            }
        } catch (\Exception $e) {
            session()->flash('error', 'An error occurred while updating the inquiry status.');
        }
    }

    public function render()
    {
        return view('livewire.dashboard.lead-inquiries.lead-inquiry-view');
    }
}
