<?php

namespace App\Livewire\Dashboard\ManufacturersSuppliers;

use App\Services\User\UserService;
use Livewire\Component;
use Livewire\Attributes\Layout;
use Illuminate\Support\Facades\Auth;
use App\Services\User\MemberCategoryService;
use Livewire\WithPagination;

#[Layout('layouts.dashboard.dashboard-app')]
class ManufacturersSuppliers extends Component
{
    use WithPagination;
    
    protected $userService;
    protected $memberCategoryService;
    public $user;
    public $categories;
    public $category = '';
    public $search = '';

    public function updatedCategory()
    {
        $this->resetPage();
    }

    public function updatedSearch()
    {
        $this->resetPage();
    }

    public function boot(UserService $userService, MemberCategoryService $memberCategoryService)
    {
        $this->userService = $userService;
        $this->memberCategoryService = $memberCategoryService;
    }

    public function mount()
    {
        $this->user = Auth::user();
        $this->categories = $this->getCategories();
    }

    protected function getCategories()
    {
        // Get only categories that belong to the current user
        // dump($this-> puser);
        $categories = $this->memberCategoryService->getAll(['user_id' => $this->user->id])->get();
        return $categories;
    }

    public function resetFilters()
    {
        $this->category = '';
        $this->search = '';
        $this->resetPage();
    }

    public function getUsers()
    {
        // Get current user's member categories
        $userCategories = $this->memberCategoryService->getAll(['user_id' => $this->user->id])->get();
        $userCategorySlugs = $userCategories->pluck('slug')->toArray();

        $searchParams = [
            'role' => ['Manufacturer', 'Supplier'],
            // Default: Show users from all of current user's member categories
            'categories' => $userCategorySlugs,
        ];

        // If specific category selected, override to show only that category
        if (!empty($this->category)) {
            $searchParams['categories'] = [$this->category];
        }


        return $this->userService->getAll($searchParams)->paginate(10);
    }

    public function render()
    {
        return view('livewire.dashboard.manufacturers-suppliers.manufacturers-suppliers', [
            'users' => $this->getUsers()
        ]);
    }
}
