<?php

namespace App\Livewire\Dashboard\Product;

use App\Enums\ProductStatus;
use App\Models\Product\Product;
use App\Services\Product\ProductService;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Livewire\Component;
use Livewire\Attributes\Layout;
use App\Filament\Dashboard\Product\ProductForm;
use Filament\Notifications\Notification;

#[Layout('layouts.dashboard.dashboard-app')]
class CreateProduct extends Component implements HasForms
{

    use InteractsWithForms;

    public ?array $data = [];
    public ?string $action = null;

    protected ProductService $productService;

    public function boot(ProductService $productService)
    {
        $this->productService = $productService;
    }

    public function mount(): void
    {
        // $this->form->fill([
        //     'product_status' => ProductStatus::Pending->value,
        // ]);
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema(
                (new ProductForm())->getForm('create')
            )
            ->model(Product::class)
            ->statePath('data');
    }

    public function saveAsDraft(): void
    {
        $this->action = 'draft';
        $this->create();   
    }

    public function create(): void
    {
        $data = $this->form->getState();
        // $data['post_status'] = match($this->action) {
        //     'draft' => PostStatus::Draft->value,
        //     default => PostStatus::Pending->value
        // };

        // Create post using productService
        $product = $this->productService->create($data);
        $this->form->model($product)->saveRelationships();

        // Show appropriate notification
        Notification::make()
            ->success()
            ->title(match($this->action) {
                'draft' => 'Saved as Draft',
                default => 'Submitted for Review'
            })
            ->body(match($this->action) {
                'draft' => 'Product has been saved as draft successfully.',
                default => 'Product has been submitted for review.'
            })
            ->duration(5000)
            ->send();

        $this->redirect(route('dashboard.product.edit', ['uuid' => $product->uuid]), navigate: true);
    }

    public function cancel(): void
    {
        $this->redirect(route('dashboard.product'), navigate: true);
    }
    public function render()
    {
        return view('livewire.dashboard.product.create-product');
    }
}
